<?php

/*
|--------------------------------------------------------------------------
| Validation Language Lines
|--------------------------------------------------------------------------
|
| The following language lines contain the default error messages used by
| the validator class. Some of these rules have multiple versions such
| as the size rules. Feel free to tweak each of these messages here.
|
*/

return [
    'accepted'             => 'Вы павінны прыняць :attribute.',
    'active_url'           => 'Поле :attribute утрымлівае несапраўдны URL.',
    'after'                => 'У полі :attribute павінна быць дата пасля :date.',
    'after_or_equal'       => 'The :attribute must be a date after or equal to :date.',
    'alpha'                => 'Поле :attribute можа мець толькі літары.',
    'alpha_dash'           => 'Поле :attribute можа мець толькі літары, лічбы і злучок.',
    'alpha_num'            => 'Поле :attribute можа мець толькі літары і лічбы.',
    'array'                => 'Поле :attribute павінна быць масівам.',
    'attached'             => 'This :attribute is already attached.',
    'before'               => 'У полі :attribute павінна быць дата да :date.',
    'before_or_equal'      => 'The :attribute must be a date before or equal to :date.',
    'between'              => [
        'array'   => 'Колькасць элементаў у поле :attribute павінна быць паміж :min і :max.',
        'file'    => 'Памер файла ў поле :attribute павінен быць паміж :min і :max кілабайт.',
        'numeric' => 'Поле :attribute павінна быць паміж :min і :max.',
        'string'  => 'Колькасць сiмвалаў у поле :attribute павінна быць паміж :min і :max.',
    ],
    'boolean'              => 'Поле :attribute павінна мець значэнне лагічнага тыпу.',
    'confirmed'            => 'Поле :attribute не супадае з пацвярджэннем.',
    'date'                 => 'Поле :attribute не з\'яўляецца датай.',
    'date_equals'          => 'The :attribute must be a date equal to :date.',
    'date_format'          => 'Поле :attribute не адпавядае фармату :format.',
    'different'            => 'Палі :attribute і :other павінны адрознівацца.',
    'digits'               => 'Даўжыня лічбавага поля :attribute павінна быць :digits.',
    'digits_between'       => 'Даўжыня лічбавага поля :attribute павінна быць паміж :min і :max.',
    'dimensions'           => 'The :attribute has invalid image dimensions.',
    'distinct'             => 'The :attribute field has a duplicate value.',
    'email'                => 'Поле :attribute павінна быць сапраўдным электронным адрасам.',
    'ends_with'            => 'The :attribute must end with one of the following: :values.',
    'exists'               => 'Выбранае значэнне для :attribute некарэктна.',
    'file'                 => 'The :attribute must be a file.',
    'filled'               => 'Поле :attribute абавязкова для запаўнення.',
    'gt'                   => [
        'array'   => 'The :attribute must have more than :value items.',
        'file'    => 'The :attribute must be greater than :value kilobytes.',
        'numeric' => 'The :attribute must be greater than :value.',
        'string'  => 'The :attribute must be greater than :value characters.',
    ],
    'gte'                  => [
        'array'   => 'The :attribute must have :value items or more.',
        'file'    => 'The :attribute must be greater than or equal :value kilobytes.',
        'numeric' => 'The :attribute must be greater than or equal :value.',
        'string'  => 'The :attribute must be greater than or equal :value characters.',
    ],
    'image'                => 'Поле :attribute павінна быць малюнкам.',
    'in'                   => 'Выбранае значэнне для :attribute памылкова.',
    'in_array'             => 'The :attribute field does not exist in :other.',
    'integer'              => 'Поле :attribute павінна быць цэлым лікам.',
    'ip'                   => 'Поле :attribute дпавінна быць сапраўдным IP-адрасам.',
    'ipv4'                 => 'The :attribute must be a valid IPv4 address.',
    'ipv6'                 => 'The :attribute must be a valid IPv6 address.',
    'json'                 => 'Поле :attribute павінна быць JSON радком.',
    'lt'                   => [
        'array'   => 'The :attribute must have less than :value items.',
        'file'    => 'The :attribute must be less than :value kilobytes.',
        'numeric' => 'The :attribute must be less than :value.',
        'string'  => 'The :attribute must be less than :value characters.',
    ],
    'lte'                  => [
        'array'   => 'The :attribute must not have more than :value items.',
        'file'    => 'The :attribute must be less than or equal :value kilobytes.',
        'numeric' => 'The :attribute must be less than or equal :value.',
        'string'  => 'The :attribute must be less than or equal :value characters.',
    ],
    'max'                  => [
        'array'   => 'Колькасць элементаў у поле :attribute не можа перавышаць :max.',
        'file'    => 'Памер файла ў поле :attribute не можа быць больш :max кілабайт).',
        'numeric' => 'Поле :attribute не можа быць больш :max.',
        'string'  => 'Колькасць сiмвалаў у поле :attribute не можа перавышаць :max.',
    ],
    'mimes'                => 'Поле :attribute павінна быць файлам аднаго з наступных тыпаў: :values.',
    'mimetypes'            => 'Поле :attribute павінна быць файлам аднаго з наступных тыпаў: :values.',
    'min'                  => [
        'array'   => 'Колькасць элементаў у поле :attribute павінна быць не менш :min.',
        'file'    => 'Памер файла ў полее :attribute павінен быць не менш :min кілабайт.',
        'numeric' => 'Поле :attribute павінна быць не менш :min.',
        'string'  => 'Колькасць сiмвалаў у поле :attribute павінна быць не менш :min.',
    ],
    'multiple_of'          => 'The :attribute must be a multiple of :value',
    'not_in'               => 'Выбранае значэнне для :attribute памылкова.',
    'not_regex'            => 'The :attribute format is invalid.',
    'numeric'              => 'Поле :attribute павінна быць лікам.',
    'password'             => 'The password is incorrect.',
    'present'              => 'The :attribute field must be present.',
    'prohibited'           => 'The :attribute field is prohibited.',
    'prohibited_if'        => 'The :attribute field is prohibited when :other is :value.',
    'prohibited_unless'    => 'The :attribute field is prohibited unless :other is in :values.',
    'regex'                => 'Поле :attribute мае памылковы фармат.',
    'relatable'            => 'This :attribute may not be associated with this resource.',
    'required'             => 'Поле :attribute абавязкова для запаўнення.',
    'required_if'          => 'Поле :attribute абавязкова для запаўнення, калі :other раўняецца :value.',
    'required_unless'      => 'Поле :attribute абавязкова для запаўнення, калі :other не раўняецца :values.',
    'required_with'        => 'Поле :attribute абавязкова для запаўнення, калі :values ўказана.',
    'required_with_all'    => 'Поле :attribute абавязкова для запаўнення, калі :values ўказана.',
    'required_without'     => 'Поле :attribute абавязкова для запаўнення, калі :values не ўказана.',
    'required_without_all' => 'Поле :attribute абавязкова для запаўнення, калі ні адно з :values не ўказана.',
    'same'                 => 'Значэнне :attribute павінна супадаць з :other.',
    'size'                 => [
        'array'   => 'Колькасць элементаў у поле :attribute павінна быць :size.',
        'file'    => 'Размер файла в поле :attribute павінен быць :size кілабайт.',
        'numeric' => 'Поле :attribute павінна быць :size.',
        'string'  => 'Колькасць сiмвалаў у поле :attribute павінна быць :size.',
    ],
    'starts_with'          => 'The :attribute must start with one of the following: :values.',
    'string'               => 'Поле :attribute павінна быць радком.',
    'timezone'             => 'Поле :attribute павінна быць сапраўдным гадзінным поясам.',
    'unique'               => 'Такое значэнне поля :attribute ўжо існуе.',
    'uploaded'             => 'The :attribute failed to upload.',
    'url'                  => 'Поле :attribute мае памылковы фармат.',
    'uuid'                 => 'The :attribute must be a valid UUID.',
    'custom'               => [
        'attribute-name' => [
            'rule-name' => 'custom-message',
        ],
    ],
    'attributes'           => [],
];
